<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

include "connect.php";

if ($conn->connect_error) {
    http_response_code(500);
    die(json_encode(["status" => "error", "message" => "Database connection failed: " . $conn->connect_error]));
}

if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
    http_response_code(200);
    exit();
}

if ($_SERVER["REQUEST_METHOD"] !== "DELETE") {
    http_response_code(405);
    die(json_encode(["status" => "error", "message" => "Only DELETE method is allowed"]));
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : null;

if (!$id) {
    http_response_code(400);
    die(json_encode(["status" => "error", "message" => "Missing or invalid ID parameter"]));
}

$stmt = $conn->prepare("DELETE FROM lookupdata WHERE id = ?");
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        http_response_code(200);
        echo json_encode([
            "status" => "success", 
            "message" => "LookUp entry deleted successfully",
            "deleted_id" => $id
        ]);
    } else {
        http_response_code(404);
        echo json_encode([
            "status" => "error", 
            "message" => "No record found with ID: $id"
        ]);
    }
} else {
    http_response_code(500);
    echo json_encode([
        "status" => "error", 
        "message" => "Database error: " . $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>