<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

include "connect.php";

if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed: " . $conn->connect_error]));
}

if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
    http_response_code(200);
    exit();
}

if ($_SERVER["REQUEST_METHOD"] !== "DELETE") {
    die(json_encode(["status" => "error", "message" => "Invalid request method"]));
}

$rawInput = file_get_contents("php://input");
$postData = json_decode($rawInput, true);

if (!is_array($postData)) {
    die(json_encode(["status" => "error", "message" => "Invalid JSON format"]));
}

if (!isset($postData['surveyorID'])) {
    die(json_encode(["status" => "error", "message" => "Missing required field: surveyorID"]));
}

$surveyorID = intval($postData['surveyorID']);

$checkStmt = $conn->prepare("SELECT surveyorID FROM surveyor WHERE surveyorID = ?");
$checkStmt->bind_param("i", $surveyorID);
$checkStmt->execute();
$checkResult = $checkStmt->get_result();

if ($checkResult->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "Surveyor not found"]);
    exit();
}

$conn->query("SET FOREIGN_KEY_CHECKS=0");

$stmt = $conn->prepare("DELETE FROM surveyor WHERE surveyorID = ?");
$stmt->bind_param("i", $surveyorID);

if ($stmt->execute() && $stmt->affected_rows > 0) {
    echo json_encode(["status" => "success", "message" => "Surveyor permanently deleted"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to delete surveyor"]);
}

$conn->query("SET FOREIGN_KEY_CHECKS=1");

$stmt->close();
$checkStmt->close();
$conn->close();
?>
