<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

include 'connect.php'; // your DB connection

// Prevent script from timing out
set_time_limit(0);
// Increase memory limit if needed
ini_set('memory_limit', '512M');

// Output JSON in streaming mode
echo "[";

// Query in chunks to avoid loading all data in memory
$limit = 5000;
$offset = 0;
$first = true;

while (true) {
    $sql = "SELECT * FROM customer_assignment LIMIT $limit OFFSET $offset";
    $result = $conn->query($sql);

    if ($result->num_rows === 0) {
        break;
    }

    while ($row = $result->fetch_assoc()) {
        if (!$first) {
            echo ",";
        }
        echo json_encode($row);
        $first = false;
    }

    $offset += $limit;
    // Flush output to the client
    ob_flush();
    flush();
}

echo "]";
$conn->close();
