<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include "connect.php";

$surveyorID = $_GET['surveyorID'] ?? '';
$type = $_GET['type'] ?? 'all'; 

if (empty($surveyorID)) {
    http_response_code(400);
    echo json_encode(["error" => "Missing surveyorID parameter"]);
    exit;
}

if (!in_array($type, ['all', 'rejected'])) {
    http_response_code(400);
    echo json_encode(["error" => "Invalid type parameter. Use 'all' or 'rejected'"]);
    exit;
}

if (!isset($pdo) && isset($conn)) {
    if ($conn->connect_error) {
        http_response_code(500);
        echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
        exit;
    }

    try {
        if ($type === 'rejected') {
            $stmt = $conn->prepare("SELECT * FROM uploaded_survey_data WHERE surveyorID = ? AND verificationStatus = '2'");
        } else {
            $stmt = $conn->prepare("SELECT * FROM uploaded_survey_data WHERE surveyorID = ? AND accountNumber IS NOT NULL AND accountNumber <> ''");
        }
        
        $stmt->bind_param("s", $surveyorID);
        $stmt->execute();
        $result = $stmt->get_result();
        $submissions = $result->fetch_all(MYSQLI_ASSOC);
        echo json_encode([
            "type" => $type,
            "count" => count($submissions),
            "data" => $submissions
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["error" => "Database error: " . $e->getMessage()]);
    }
    
    $conn->close();
    exit;
}