<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");


if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("HTTP/1.1 200 OK");
    exit();
}

include 'connect.php';

class SubmissionVerifier {
    private $conn;

    public function __construct($conn) {
        $this->conn = $conn;
    }

    public function logData($message) {
        file_put_contents("verify_log.txt", date("Y-m-d H:i:s") . " - $message\n", FILE_APPEND);
    }

    public function verify($data) {
        $this->logData("Parsed Data: " . print_r($data, true));

        $required = ['accountNumber', 'approvalStatus', 'approvalComments', 'approvedBy', 'approvalDate'];
        foreach ($required as $field) {
            if (!isset($data[$field]) || $data[$field] === '') {
                $msg = "Missing or empty field: $field";
                http_response_code(400);
                echo json_encode(['success' => false, 'message' => $msg]);
                return;
            }
        }

        $data['appRejectReason'] = isset($data['appRejectReason']) ? (string)$data['appRejectReason'] : '';

        try {
            $stmt = $this->conn->prepare("
                UPDATE uploaded_survey_data
                SET approvalStatus = ?, 
                    approvalComments = ?, 
                    approvedBy = ?, 
                    approvalDate = ?,
                    appRejectReason = ?
                WHERE accountNumber = ?
            ");

            if (!$stmt) {
                $this->logData("🔥 Prepare failed: " . $this->conn->error);
                http_response_code(500);
                echo json_encode(['success' => false, 'message' => 'Prepare failed: ' . $this->conn->error]);
                return;
            }

            $stmt->bind_param(
                "isssss",
                $data['approvalStatus'],
                $data['approvalComments'],
                $data['approvedBy'],
                $data['approvalDate'],
                $data['appRejectReason'],
                $data['accountNumber']
            );

            if (!$stmt->execute()) {
                $this->logData("🔥 Execute failed: " . $stmt->error);
                http_response_code(500);
                echo json_encode(['success' => false, 'message' => 'Execute failed: ' . $stmt->error]);
                return;
            }

            $affected = $stmt->affected_rows;
            $this->logData("✅ Executed update for accountNumber = {$data['accountNumber']}, affected_rows = $affected");

            if ($affected > 0) {
                echo json_encode(['success' => true, 'message' => 'Approval updated successfully.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'No records were updated.']);
            }
        } catch (Exception $e) {
            $this->logData("🔥 Exception: " . $e->getMessage());
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => "DB error: " . $e->getMessage()]);
        }
    }
}

$json = file_get_contents('php://input');

$data = json_decode($json, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    $errorMsg = json_last_error_msg();
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid JSON data: ' . $errorMsg]);
    exit;
}

if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}


$verifier = new SubmissionVerifier($conn);
$verifier->verify($data);

$conn->close();
?>