<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include "connect.php";

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['surveyorIDs']) || !isset($data['newEmpID'])) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'status' => 400,
        'message' => 'Surveyor IDs and new Supervisor ID are required',
        'data' => null
    ]);
    exit();
}

$newEmpID = $conn->real_escape_string($data['newEmpID']);
$surveyorIDs = array_map([$conn, 'real_escape_string'], $data['surveyorIDs']);
$surveyorIDsString = "'" . implode("','", $surveyorIDs) . "'";

$query = "UPDATE surveyor SET empID = '$newEmpID' WHERE surveyorID IN ($surveyorIDsString)";
$result = $conn->query($query);

if ($result) {
    echo json_encode([
        'success' => true,
        'status' => 200,
        'message' => 'Surveyors reassigned successfully',
        'data' => null
    ]);
} else {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'status' => 500,
        'message' => 'Failed to reassign surveyors',
        'data' => null
    ]);
}
?>
