<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include "connect.php";

if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed: " . $conn->connect_error]));
}

$rawInput = file_get_contents("php://input");
$postData = json_decode($rawInput, true);

if (!is_array($postData)) {
    http_response_code(400);
    die(json_encode(["status" => "error", "message" => "Invalid JSON format"]));
}

if (!isset($postData['empID'], $postData['firstName'], $postData['lastName'])) {
    http_response_code(400);
    die(json_encode(["status" => "error", "message" => "Missing required fields"]));
}

$empID = $postData['empID'];
$firstName = $postData['firstName'];
$lastName = $postData['lastName'];
$email = $postData['email'] ?? null;
$phoneNumber = $postData['phoneNumber'] ?? null;
$role = $postData['role'] ?? null;
$businessUnit = $postData['businessUnit'] ?? null;

$password = isset($postData['password']) && !empty($postData['password']) ? $postData['password'] : null;

if ($password) {
    $stmt = $conn->prepare("UPDATE users SET firstName = ?, lastName = ?, email = ?, phoneNumber = ?, role = ?, businessUnit = ?, password = ? WHERE empID = ?");
    $stmt->bind_param("ssssssss", $firstName, $lastName, $email, $phoneNumber, $role, $businessUnit, $password, $empID);
} else {
    $stmt = $conn->prepare("UPDATE users SET firstName = ?, lastName = ?, email = ?, phoneNumber = ?, role = ?, businessUnit = ? WHERE empID = ?");
    $stmt->bind_param("sssssss", $firstName, $lastName, $email, $phoneNumber, $role, $businessUnit, $empID);
}

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Employee updated successfully"]);
} else {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Error: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>