<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
include "connect.php";

header('Content-Type: application/json');

if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed: " . $conn->connect_error]));
}

$rawInput = file_get_contents("php://input");
$postData = json_decode($rawInput, true);

if (!is_array($postData)) {
    die(json_encode(["status" => "error", "message" => "Invalid JSON format"]));
}

if (!isset($postData['surveyorID'], $postData['firstName'], $postData['lastName'], $postData['email'], $postData['phoneNumber'], $postData['password'], $postData['empID'])) {
    die(json_encode(["status" => "error", "message" => "Missing required fields"]));
}

$stmt = $conn->prepare("UPDATE surveyor SET empID = ?, firstName = ?, lastName = ?, email = ?, phoneNumber = ?, password = ? WHERE surveyorID = ?");

$stmt->bind_param("sssssss", 
    $postData['empID'], 
    $postData['firstName'], 
    $postData['lastName'], 
    $postData['email'], 
    $postData['phoneNumber'], 
    $postData['password'], 
    $postData['surveyorID']
);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode(["status" => "success", "message" => "Surveyor updated successfully"]);
    } else {
        echo json_encode(["status" => "error", "message" => "No record found with the provided surveyorID"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Error: " . $stmt->error]);
}
$stmt->close();
$conn->close();
?>
