<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

include 'connect.php';

$data = json_decode(file_get_contents("php://input"));
$accountNumber = $data->accountNumber;
$action = $data->action;
$verifiedBy = $data->verifiedBy;
$verificationDate = $data->verificationDate;

try {
    $stmt = $conn->prepare("UPDATE data_anomalies 
                           SET verified = 1, 
                               verification_action = ?,
                               verified_by = ?,
                               verification_date = ?
                           WHERE accountNumber = ?
                           AND verified = 0");
    $stmt->bind_param("ssss",$action,  $verifiedBy, $verificationDate, $accountNumber);
    $stmt->execute();
    
    echo json_encode(["success" => true, "message" => "All anomalies verified"]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Error: " . $e->getMessage()]);
}

$conn->close();
?>